﻿using System;
using TYTD.Server.Models;
using TYTD.Server.Functions;
using System.Threading;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Linq;
using System.Text;
using SimpleHttp;

namespace TYTD
{
    public abstract class Api : IDisposable
    {
        public virtual void OnStart()
        {
            Console.WriteLine("Extension Loaded");
        }
        internal string storage;
        protected string StorageLocation { get { return storage; } }

        public virtual string Name { get { return Path.GetFileName(StorageLocation); } }
        private System.Timers.Timer t = null;
        protected void SetTimer(TimeSpan timespan)
        {
            if(t == null)
            {
                t = new System.Timers.Timer();
                t.Elapsed += (sender, e) =>
                {
                    TimerElapsed();
                };
            }
            t.Interval = timespan.TotalMilliseconds;
           
            t.Start();
        }
        public virtual void SetProgress(double progress)
        {

        }
        public virtual void OnEnd()
        {

        }
                public bool TimerEnabled { get { if (t != null) { return t.Enabled; } else { return false; } } set { if (t != null) { t.Enabled = value; } } }
        public virtual IEnumerable<KeyValuePair<string, string>> GetUrls()
        {
            yield return new KeyValuePair<string, string>("Home",$"api/Extensions/{Name}");
        }
        protected virtual void TimerElapsed()
        {
            Console.WriteLine("Event Fired");
        }
        public Api AddItem(string id)
        {
            Downloader.DownloadItem(id);
            return this;
        }
        internal void SendDLStart(object sender,DownloadStartEventArgs e)
        {
            if(DownloadStart != null)
            {
                DownloadStart.Invoke(sender, e);
            }
        }
        internal void SendDLInfoStart(object sender, DownloadInfoStartEventArgs e)
        {
            if (DownloadInfoStart != null)
            {
                DownloadInfoStart.Invoke(sender, e);
            }
        }
        internal void SendDLComplete(object sender, DownloadCompleteEventArgs e)
        {
            if (DownloadComplete != null)
            {
                DownloadComplete.Invoke(sender, e);
            }
        }
        public event EventHandler<DownloadInfoStartEventArgs> DownloadInfoStart;
        public event EventHandler<DownloadStartEventArgs> DownloadStart;
        public event EventHandler<DownloadCompleteEventArgs> DownloadComplete;
    
        public void Dispose()
        {
            if( t != null)
            {
                t.Dispose();
            }
            OnEnd();
        }
    }

    public class DownloadCompleteEventArgs : EventArgs
    {
        public bool RegularFile { get; set; }
        public SavedVideo Video { get; set; }

    }

    public class DownloadInfoStartEventArgs : EventArgs
    {
       
        public SavedVideo Video { get; set; }

    }
    public class DownloadStartEventArgs : EventArgs
    {
        public bool RegularFile { get; set; }
        public SavedVideo Video { get; set; }
        public bool Cancel { get; set; }
    }
  
    public static class ApiLoader 
    {
       public static string Page { get; private set; }
        internal static List<Api> apis = new List<Api>();

        internal static void DownloadStarted(object sender,DownloadStartEventArgs evt)
        {
            foreach(var api in apis)
            {
                api.SendDLStart(sender, evt);
            }
        }
        internal static void DownloadComplete(object sender, DownloadCompleteEventArgs evt)
        {
            foreach (var api in apis)
            {
                api.SendDLComplete(sender, evt);
            }
        }
        internal static void SetProgress(double progress)
        {
            foreach (var api in apis)
            {
                api.SetProgress(progress);
            }
        }
        internal static void DownloadInfoStart(object sender, DownloadInfoStartEventArgs evt)
        {
            foreach (var api in apis)
            {
                api.SendDLInfoStart(sender, evt);
            }
        }

        public static void Dispose()
        {
            foreach(var api in apis)
            {
                api.Dispose();
            }
        }
        public static void GenerateTr(Api api,StringBuilder b)
        {

            string data = "";
            string root = Path.Combine(Environment.CurrentDirectory, "config");
            string fallbackIcon = Path.Combine(root, "default_icon.png");
            string icon = Path.Combine(root, "apiicons", api.Name + ".png");
            string icon2 = File.Exists(icon) ? icon : fallbackIcon;
            if (File.Exists(icon2))
            {

                data = Convert.ToBase64String(File.ReadAllBytes(icon2));
            }


            b.Append($"<tr><td><h3>{api.Name}</h3><img src=\"data:image/png;base64,{data}\" alt=\"{api.Name}\"></td><td>");
            foreach (var link in api.GetUrls())
            {
                b.Append($"<a href=\"{link.Value}\">{link.Key}</a><br>");
            }
            b.Append("</td></tr>");

        }
        internal static void Load(StringBuilder b,string dll,string confpath)
        {
            var asm=Assembly.LoadFrom(dll);

            foreach (var item in asm.GetTypes())
            {
                if(typeof(Api).IsAssignableFrom(item))
                {
                    Api api = (Api)Activator.CreateInstance(item);
                    api.storage = confpath;
                    apis.Add(api);
                    api.OnStart();
                    GenerateTr(api, b);
                }
            }
            
        }
        public static void Init()
        {
            StringBuilder b = new StringBuilder();
            string root = Path.Combine(Environment.CurrentDirectory,"config", "apidll");
            string appconfroot = Path.Combine(Environment.CurrentDirectory,"config", "apistore");
            foreach(var dir in Directory.GetDirectories(root))
            {
                string name = Path.GetFileName(dir);
                string dllpath = Path.Combine(root, name, name + ".dll");
                string confpath = Path.Combine(appconfroot, name);
                if(File.Exists(dllpath))
                {
                    Directory.CreateDirectory(confpath);
                    Load(b,dllpath, confpath);
                }
            }
            Dictionary<string, string> templating = new Dictionary<string, string>();
            templating.Add("Items", b.ToString());
            Page = Templating.RenderFile(Path.Combine("WebSite", "extensions.html"), templating);
        }
    }
}
