﻿using YoutubeExplode.Channels;
using YoutubeExplode.Playlists;
using YoutubeExplode.Videos;

namespace TYTD.Server.Models
{
    public enum InfoType
    {
        Video=0,
        Playlist=1,
        Channel=2,
        User=3,
        ClosedCaptions=4,
        FileDownload=5
    }
    public class IDResolutionTypeTriplet
    {
        public string Id { get; set; }
        public InfoType Type { get; set; }
        public Resolution Resolution { get; set; }
        public InfomationQueueItem ToInfomationQueueItem(bool download=true)
        {
            switch(Type)
            {
                case InfoType.Video:
                    VideoId vid = Id;
                   
                        return new InfomationQueueItem(vid, Resolution, download);
                    
                   
                case InfoType.Playlist:
                    PlaylistId pid = Id;
                    return new InfomationQueueItem(pid, Resolution, download);

                  
                case InfoType.Channel:
                    ChannelId cid = Id;
                    return new InfomationQueueItem(cid, Resolution, download);

                case InfoType.User:
                    UserName user = Id;
                   
                        return new InfomationQueueItem(user, Resolution, download);
                case InfoType.ClosedCaptions:
                    VideoId vid2 = Id;
                    return new InfomationQueueItem(vid2);
                   
            }
            return null;
        }
    }
}