﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TYTD.Server.Functions;

namespace TYTD.Server.Models
{
   public class SavedChannel
    {
        public static SavedChannel FromChannel(YoutubeExplode.Channels.Channel c, Action<int, int, string,string> downloadThumbnail)
        {
            SavedChannel sc = new SavedChannel();
           sc.Id= c.Id;
            sc.Title=c.Title;
            sc.Url = c.Url;
            foreach(var thumb in c.Thumbnails)
            {
                downloadThumbnail(thumb.Resolution.Width, thumb.Resolution.Height,c.Id, thumb.Url);
            }
            return sc;
        }
        public string Id { get; set; }
        public string Title { get; set; }

        public string Url { get; set; }
    }
}
