﻿using System;
using System.Collections.Generic;
using System.IO;
using Hyperlinq;
namespace Site
{
    public class YouTubeSite
    {
        public YouTubeSite()
        {
            
        }
        public HElement[] GetBootStrap()
        {
            return new HElement[] {
                H.link(e=> e.href("https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css").rel("stylesheet").Custom("integrity","sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC").Custom("crossorigin","anonymous")),
                H.script(e=> e.src("https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js").Custom("integrity","sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM").Custom("crossorigin","anonymous"))

            };
        }
        public void RegisterPages(List<string> pages)
        {
            pages.Add("/");
            pages.Add("/index.html");
        }
        public object[] GetPage2(string page,Dictionary<string,string> args,string con_type)
        {
            string con_type0 = con_type;

          return new object[] { GetPage(page, args, ref con_type0), con_type };
        }
        public MyResponse GetPage(string page,Dictionary<string,string> args,ref string content_type)
        {
            if(page == "/" || page == "/index.html")
            {
                return 
                H.html(
                    H.head(
                        H.title("Tesses YouTube Downloader")
                        ),
                    H.body(
                        H.h1("Demi Lovato is an awesome boy")
                        )
                );
            }
            return MyResponse.Empty;
        }
    }

    public class MyResponse
    {
        public bool IsEmpty = false;
        public byte[] Data;
        public static MyResponse Empty { get { return new MyResponse() { IsEmpty = true }; } }
        public static implicit operator MyResponse(Stream strm)
        {
            MemoryStream strm2=new MemoryStream();
            strm.CopyTo(strm2);
            strm.Dispose();
            return strm2.ToArray();
        }
        public static implicit operator MyResponse(string str)
        {
            return System.Text.Encoding.UTF8.GetBytes(str);
        }
        public static implicit operator MyResponse(HElement elmt)
        {
            return elmt.ToString();
        }
        public static implicit operator MyResponse(byte[] data)
        {
            return new MyResponse() { Data = data };
        }
        public static implicit operator byte[](MyResponse resp)
        {
            return resp.Data;
        }
    }
}
