﻿using System;   
using System.Diagnostics;
using System.IO;
using System.Net;
namespace youtube_downloader.Server.Functions
{
    internal class ffmpeg
    {
        internal static string FFMPEG = ffmpeg.get_ffmpeg();

        private static string get_ffmpeg()
        {
            Directory.CreateDirectory("config");

            string ffmpgloc = Path.Combine(Environment.CurrentDirectory, "config", "ffmpeg.txt"); 
            if (File.Exists(ffmpgloc))
            {
                return File.ReadAllText(ffmpgloc);
            }

            return "ffmpeg";
        }
        public static void on_video_done(string id,int res)
        {

            string path_to_video_id = Path.Combine(Downloader.DL.StorageLocation,"Info",$"{id}.json");
            Directory.CreateDirectory("config");
           
            string vdone= Path.Combine(Environment.CurrentDirectory, "config", "done");
            try
            {

                using (var p = new Process())
                {
                    p.StartInfo.FileName = vdone;
                    p.StartInfo.Arguments = $"\"{id}\" \"{path_to_video_id}\" {res}";
                    p.StartInfo.UseShellExecute = false;
                    p.StartInfo.CreateNoWindow = true;
                    p.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
                    p.Start();
                }
            }
            catch (Exception ex)
            {
                _ = ex;
            }
        }
        internal static void mux(string mypath, string mypathCompleteAudio, string mypathIncompleteConverting)
        {
            using (var p = new Process())
            {
                p.StartInfo.FileName = FFMPEG;
                p.StartInfo.Arguments = $"-i \"{mypath}\" -i \"{mypathCompleteAudio}\" -c copy -map 0:v -map 1:a \"{mypathIncompleteConverting}\"";
                p.StartInfo.UseShellExecute = false;
                p.StartInfo.CreateNoWindow = true;
                p.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
                if (p.Start())
                {
                    p.WaitForExit();
                }
            }
        }

        internal static void download_thumbnail(string tnail, string p2)
        {
		string thumbsfile=Downloader.DL.GetPath(true, "thumbs");
	    if(File.Exists(thumbsfile))
	    {

            	using (var p = new Process())
            	{
                	p.StartInfo.FileName = "/bin/bash";
                	p.StartInfo.Arguments = $"\"{thumbsfile}\" \"{tnail}\" \"{p2}\"";
                	p.StartInfo.UseShellExecute = false;
                	p.StartInfo.CreateNoWindow = true;
                	p.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
                	if (p.Start())
                	{
                    	p.WaitForExit();
                	}
            	}
		}else{
			using(var wc = new WebClient()
			{
				wc.DownloadFile(tnail,p2);
			}
		}
        }
    }

    public class ProgressTwo
    {
        double vanda;
        double v;
        double a;

        double vval=0;
        double aval=0;
        IProgress<double> report;
        public ProgressTwo(double vsize,double asize,IProgress<double> p)
        {
            vanda = vsize + asize;
            v = vsize / vanda; //v = 0.1 if vsize == 20 and vanda=200
            a = asize / vanda;
            Video = new Progress<double>(ProgressVideo);
            Audio = new Progress<double>(ProgressAudio);
            report = p;
        }

        private void ProgressAudio(double d)
        {
            aval = d * a;
            Process();
        }

        private void ProgressVideo(double d)
        {
            vval = d * v;
            Process();
        }
        private void Process()
        {
            report.Report(aval + vval);
        }
        public Progress<double> Video { get; set; }
        public Progress<double> Audio { get; set; }
    }

}