﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using youtube_downloader.Server.Functions;
using YoutubeExplode.Videos;
namespace TessesYoutubeDownloader.Server.Models
{
   
    public enum Resolution
    {
        Convert=0,
        NoConvert=1,
        Audio=2
    }
    public struct ClosedCaptions
    {
        public ClosedCaptions(VideoId id)
        {
            VideoId = id;
        }
        public VideoId VideoId;
    }
    public class SavedVideoObject
    {
        public SavedVideoObject()
        {
            RegularFile = false;
        }
        public SavedVideoObject(string url)
        {
            RegularFile = true;
            Video = new SavedVideo() { Id = url };
        }
        public bool RegularFile { get; set; }


        public SavedVideo Video { get; set; }
        public Resolution Resolution { get; set; }
    }
   public class SavedVideo
    {
       
        public static SavedVideoObject CreateFrom(Resolution res,YoutubeExplode.Videos.Video v,Action<int,int,string,string> downloadThumbnail)
        {
            
            SavedVideo sv = new SavedVideo();
            sv.Thumbnails = new List<Tuple<int, int, string>>();
            sv.Title = v.Title;
            sv.UploadDate = v.UploadDate.ToString();
            sv.Id = v.Id;
            sv.AuthorChannelId = v.Author.ChannelId;
            sv.AuthorTitle = v.Author.Title;
            sv.Description = v.Description;
            sv.Dislikes = v.Engagement.DislikeCount;
            sv.Duration = v.Duration.GetValueOrDefault().TotalSeconds;
            sv.Keywords = v.Keywords.ToArray();
            sv.Likes = v.Engagement.LikeCount;
            sv.Views = v.Engagement.ViewCount;
            sv.Thumbnails = v.Thumbnails.Select<YoutubeExplode.Common.Thumbnail,Tuple<int,int,string>>((e) => { return new Tuple<int, int, string>(e.Resolution.Width, e.Resolution.Height, e.Url); }).ToList();
            foreach(var thumb in v.Thumbnails)
            {

                downloadThumbnail(thumb.Resolution.Width, thumb.Resolution.Height,v.Id, thumb.Url);
            }
            SavedVideoObject obj = new SavedVideoObject();
            obj.Video = sv;
            obj.Resolution = res;
            return obj;

        }
        public string Title { get; set; }
        public string UploadDate { get; set; }
        public string[] Keywords { get; set; }
        public string Id { get; set; }
        public string AuthorTitle { get; set; }
        public string AuthorChannelId { get; set; }

        public string Description { get; set; }

        public double Duration { get; set; }

        public long Views { get; set; }
        public long Likes { get; set; }
        public long Dislikes { get; set; }
        public List<Tuple<int,int,string>> Thumbnails { get; set; }
    }
}
