const search_list = document.getElementById('search_list');
const text_field = document.getElementById('text_field');
const button = document.getElementById('search_button');

button.addEventListener('click', ()=>{
    search(text_field.value);
});

function addVideo(id,title)
{
    let row = document.createElement('tr');
    let image_col = document.createElement('td');
    let title_col = document.createElement('td');
    let type_col = document.createElement('td');
    let id_col = document.createElement('td');
    let res_col = document.createElement('td');
   
    // image
    let img_link = document.createElement('a');
    img_link.href = "api/AddVideo/" + id;
    let img = document.createElement('img');
    img.src = "api/Storage/File/Thumbnails/120x90/" + id + ".jpg";
    img.alt = title;
    img.width = 128;
    img.height = 72;
    img_link.appendChild(img);
    image_col.appendChild(img_link);
    row.appendChild(image_col);

    //title
    let title_link = document.createElement('a');
    title_link.href="api/AddVideo/" + id;
    title_link.textContent = title;
    title_col.appendChild(title_link);
    row.appendChild(title_col);

    //type constant
    type_col.textContent = "Video";
    row.appendChild(type_col);

    //id
    id_col.textContent = id;
    row.appendChild(id_col);
    //other res
    let link0 = document.createElement('a');
    let sep = document.createElement('a');
    let link1 = document.createElement('a');
    link0.textContent = "Highest";
    link0.href="api/AddVideo/0/" + id;
    res_col.appendChild(link0);
    sep.textContent = "|";
    res_col.appendChild(sep);
    link1.textContent = "Audio Only";
    link1.href="api/AddVideo/2/" + id;
    res_col.appendChild(link1);
    row.appendChild(res_col)
    //append to list
    search_list.appendChild(row);
}
function addPlaylist(id,title)
{
    let row = document.createElement('tr');
    let image_col = document.createElement('td');
    let title_col = document.createElement('td');
    let type_col = document.createElement('td');
    let id_col = document.createElement('td');
    let res_col = document.createElement('td');
    // image
    let img_link = document.createElement('a');
    img_link.href = "api/AddPlaylist/" + id;
    let img = document.createElement('img');
    img.src = "api/Storage/File/Thumbnails/196x110/" + id + ".jpg";
    img.alt = title;
    img.width = 128;
    img.height = 72;
    img_link.appendChild(img);
    image_col.appendChild(img_link);
    row.appendChild(image_col);

    //title
    let title_link = document.createElement('a');
    title_link.href="api/AddPlaylist/" + id;
    title_link.textContent = title;
    title_col.appendChild(title_link);
    row.appendChild(title_col);

    //type constant
    type_col.textContent = "Playlist";
    row.appendChild(type_col);

    //id
    id_col.textContent = id; 
    row.appendChild(id_col);
    //other resolutions
    let link0 = document.createElement('a');
    let sep = document.createElement('a');
    let link1 = document.createElement('a');
    link0.textContent = "Highest";
    link0.href="api/AddPlaylist/0/" + id;
    res_col.appendChild(link0);
    sep.textContent = "|";
    res_col.appendChild(sep);
    link1.textContent = "Audio Only";
    link1.href="api/AddPlaylist/2/" + id;
    res_col.appendChild(link1);
    row.appendChild(res_col)

   
    //append to list
    search_list.appendChild(row);
}
function addChannel(id,title)
{
    let row = document.createElement('tr');
    let image_col = document.createElement('td');
    let title_col = document.createElement('td');
    let type_col = document.createElement('td');
    let id_col = document.createElement('td');
    let res_col = document.createElement('td');
    // image
    let img_link = document.createElement('a');
    img_link.href = "api/AddChannel/" + id;
    let img = document.createElement('img');
    img.src = "api/Storage/File/Thumbnails/900x900/" + id + ".jpg";
    img.alt = title;
    img.width = 128;
    img.height = 72;
    img_link.appendChild(img);
    image_col.appendChild(img_link);
    row.appendChild(image_col);

    //title
    let title_link = document.createElement('a');
    title_link.href="api/AddChannel/" + id;
    title_link.textContent = title;
    title_col.appendChild(title_link);
    row.appendChild(title_col);

    //type constant
    type_col.textContent = "Channel";
    row.appendChild(type_col);

    //id
    id_col.textContent = id; 
    row.appendChild(id_col);
    //other resolutions
    let link0 = document.createElement('a');
    let sep = document.createElement('a');
    let link1 = document.createElement('a');
    link0.textContent = "Highest";
    link0.href="api/AddChannel/0/" + id;
    res_col.appendChild(link0);
    sep.textContent = "|";
    res_col.appendChild(sep);
    link1.textContent = "Audio Only";
    link1.href="api/AddChannel/2/" + id;
    res_col.appendChild(link1);
    row.appendChild(res_col)

   
    //append to list
    search_list.appendChild(row);
}
function search(query){
    search_list.textContent = '';
    var xmlhttp = new XMLHttpRequest();


    xmlhttp.onreadystatechange = function() {
    
        if (this.readyState == 4 && this.status == 200) {
                var myData = JSON.parse(this.responseText);
                myData.forEach((item, index) => {
                if(item.Kind == 0){
                    addVideo(item.Id,item.Title);
                }
                if(item.Kind == 1)
                {
                    addPlaylist(item.Id,item.Title);
                }
                if(item.Kind == 2){
                    addChannel(item.Id,item.Title);
                }
            });
        };
    };
    
  xmlhttp.open("GET", "api/Search/" + encodeUri(query), true);
    xmlhttp.send();
}
